/**********************************************************************************************
 * Filename:       app_snippets.c
 *
 * Description:    This file contains snippets needed to utilize the generated services.
 *
 *                 Generated by:
 *                 BDS version: 1.1.3135.0
 *                 Plugin:      Texas Instruments BLE SDK GATT Server plugin 1.0.8
 *                 Time:        Sat Jun 24 2017 16:55:14 GMT+01:00
 *
 * Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************************************/
//...
#include <ti/sysbios/knl/Semaphore.h>
#include <ti/sysbios/knl/Queue.h>

//...
#include "LED_Service.h"
#include "Button_Service.h"
#include "Data_Service.h"
#include "RELAY_SERVICE.h"
#include "Digital_Input_Service.h"

//...

// Types of messages that can be sent to the application task
typedef enum
{
  APP_MSG_SERVICE_WRITE = 0,
  APP_MSG_SERVICE_CFG,
  APP_MSG_SEND_NOTIFICATION,
  APP_MSG_GAP_STATE_CHANGE
} app_msg_types_t;

// Struct for messages sent to the application task
typedef struct
{
  Queue_Elem       _elem;
  app_msg_types_t  type;
  uint8_t          pdu[];
} app_msg_t;

// Struct for messages about characteristic data
typedef struct
{
  uint16_t svcUUID; // UUID of the service
  uint16_t dataLen; // 
  uint8_t  paramID; // Index of the characteristic
  uint8_t  data[];  // Flexible array member, extended to malloc - sizeof(.)
} char_data_t;

// Semaphore globally used to post events to the application thread
static ICall_Semaphore sem; // Already present in sample applications.

// Queue object used for application messages.
static Queue_Struct applicationMsgQ;
static Queue_Handle hApplicationMsgQ;


// Clock structs for periodic notification example
static Clock_Struct bs_BUTTON0_clock;
static Clock_Struct bs_BUTTON1_clock;
static Clock_Struct bs_BUTTON2_T1_clock;
static Clock_Struct bs_BUTTON3_T2_clock;
static Clock_Struct ds_Stream_clock;
static Clock_Struct dis_IN1_clock;
static Clock_Struct dis_IN2_clock;
static Clock_Struct dis_IN3_clock;

//...

// Declaration of BDS generated service callback handlers
static void user_LedService_ValueChangeCB( uint16_t connHandle, uint8_t paramID, uint8_t *pValue, uint16_t len ); // Callback from the service on writes.
static void user_LedService_ValueChangeDispatchHandler(char_data_t *pCharData); // Local handler called from the Task context of this task.
// Button_Service has no writeable characteristics
static void user_ButtonService_CfgChangeCB( uint16_t connHandle, uint8_t paramID, uint8_t *pValue, uint16_t len ); // Callback from the service on noti/ind config change.
static void user_ButtonService_CfgChangeDispatchHandler(char_data_t *pCharData);
static void user_DataService_ValueChangeCB( uint16_t connHandle, uint8_t paramID, uint8_t *pValue, uint16_t len ); // Callback from the service on writes.
static void user_DataService_ValueChangeDispatchHandler(char_data_t *pCharData); // Local handler called from the Task context of this task.
static void user_DataService_CfgChangeCB( uint16_t connHandle, uint8_t paramID, uint8_t *pValue, uint16_t len ); // Callback from the service on noti/ind config change.
static void user_DataService_CfgChangeDispatchHandler(char_data_t *pCharData);
static void user_RelayService_ValueChangeCB( uint16_t connHandle, uint8_t paramID, uint8_t *pValue, uint16_t len ); // Callback from the service on writes.
static void user_RelayService_ValueChangeDispatchHandler(char_data_t *pCharData); // Local handler called from the Task context of this task.
// Digital_Input_Service has no writeable characteristics
static void user_DigitalInputService_CfgChangeCB( uint16_t connHandle, uint8_t paramID, uint8_t *pValue, uint16_t len ); // Callback from the service on noti/ind config change.
static void user_DigitalInputService_CfgChangeDispatchHandler(char_data_t *pCharData);

// Callback handlers for the clock objects
static void user_ButtonService_clockSwiHandler(UArg paramID);
static void user_DataService_clockSwiHandler(UArg paramID);
static void user_DigitalInputService_clockSwiHandler(UArg paramID);

// Task handler for sending notifications.
static void user_updateCharVal(char_data_t *pCharData);

static void user_enqueueRawAppMsg( app_msg_types_t appMsgType, uint8_t *pData, uint16_t len );
static void user_enqueueCharDataMsg( app_msg_types_t appMsgType, uint16_t serviceUUID, 
                                       uint16_t connHandle, uint8_t paramID, 
                                       uint8_t *pValue, uint16_t len );


// GAP Role Callbacks
static gapRolesCBs_t user_gapRoleCBs =
{
  user_gapStateChangeCB     // Profile State Change Callbacks
};

// GAP Bond Manager Callbacks
static gapBondCBs_t user_bondMgrCBs =
{
  NULL, // Passcode callback (not used by application)
  NULL  // Pairing / Bonding state Callback (not used by application)
};


// Service callback structure for registering our handlers with the service
// LED Service callback handler. The type LED_ServiceCBs_t is defined in LED_Service.h
static LedServiceCBs_t user_LED_ServiceCBs =
{
  .pfnChangeCb    = user_LedService_ValueChangeCB, // Characteristic value change callback handler
  .pfnCfgChangeCb = NULL, // No notification-/indication enabled chars in LED Service
};

// Button Service callback handler. The type Button_ServiceCBs_t is defined in Button_Service.h
static ButtonServiceCBs_t user_Button_ServiceCBs =
{
  .pfnChangeCb    = NULL, // No writable chars in Button Service, so no change handler.
  .pfnCfgChangeCb = user_ButtonService_CfgChangeCB, // Noti/ind configuration callback handler
};

// Data Service callback handler. The type Data_ServiceCBs_t is defined in Data_Service.h
static DataServiceCBs_t user_Data_ServiceCBs =
{
  .pfnChangeCb    = user_DataService_ValueChangeCB, // Characteristic value change callback handler
  .pfnCfgChangeCb = user_DataService_CfgChangeCB, // Noti/ind configuration callback handler
};

// RELAY SERVICE callback handler. The type RELAY_SERVICECBs_t is defined in RELAY_SERVICE.h
static RelayServiceCBs_t user_RELAY_SERVICECBs =
{
  .pfnChangeCb    = user_RelayService_ValueChangeCB, // Characteristic value change callback handler
  .pfnCfgChangeCb = NULL, // No notification-/indication enabled chars in RELAY SERVICE
};

// Digital Input Service callback handler. The type Digital_Input_ServiceCBs_t is defined in Digital_Input_Service.h
static DigitalInputServiceCBs_t user_Digital_Input_ServiceCBs =
{
  .pfnChangeCb    = NULL, // No writable chars in Digital Input Service, so no change handler.
  .pfnCfgChangeCb = user_DigitalInputService_CfgChangeCB, // Noti/ind configuration callback handler
};


//...



// taskFxn_init(..)
// {
  Clock_Params clockParams;
  Clock_Params_init(&clockParams);
  clockParams.period = 5000 * (1000 / Clock_tickPeriod); // 5000ms period

  // Clock struct initialization for periodic notification example
  // Clock callbacks only have one parameter, so make one callback handler per service.
  clockParams.arg = BS_BUTTON0_ID;
  Clock_construct(&bs_BUTTON0_clock,
                  user_ButtonService_clockSwiHandler,
                  0,
                  &clockParams);
  clockParams.arg = BS_BUTTON1_ID;
  Clock_construct(&bs_BUTTON1_clock,
                  user_ButtonService_clockSwiHandler,
                  0,
                  &clockParams);
  clockParams.arg = BS_BUTTON2_T1_ID;
  Clock_construct(&bs_BUTTON2_T1_clock,
                  user_ButtonService_clockSwiHandler,
                  0,
                  &clockParams);
  clockParams.arg = BS_BUTTON3_T2_ID;
  Clock_construct(&bs_BUTTON3_T2_clock,
                  user_ButtonService_clockSwiHandler,
                  0,
                  &clockParams);
  clockParams.arg = DS_STREAM_ID;
  Clock_construct(&ds_Stream_clock,
                  user_DataService_clockSwiHandler,
                  0,
                  &clockParams);
  clockParams.arg = DIS_IN1_ID;
  Clock_construct(&dis_IN1_clock,
                  user_DigitalInputService_clockSwiHandler,
                  0,
                  &clockParams);
  clockParams.arg = DIS_IN2_ID;
  Clock_construct(&dis_IN2_clock,
                  user_DigitalInputService_clockSwiHandler,
                  0,
                  &clockParams);
  clockParams.arg = DIS_IN3_ID;
  Clock_construct(&dis_IN3_clock,
                  user_DigitalInputService_clockSwiHandler,
                  0,
                  &clockParams);

  // Initialize queue for application messages.
  // Note: Used to transfer control to application thread
  Queue_construct(&applicationMsgQ, NULL);
  hApplicationMsgQ = Queue_handle(&applicationMsgQ);



  // Add services to GATT server
  LedService_AddService( selfEntity );
  LedService_RegisterAppCBs(&user_LED_ServiceCBs);
  ButtonService_AddService( selfEntity );
  ButtonService_RegisterAppCBs(&user_Button_ServiceCBs);
  DataService_AddService( selfEntity );
  DataService_RegisterAppCBs(&user_Data_ServiceCBs);
  RelayService_AddService( selfEntity );
  RelayService_RegisterAppCBs(&user_RELAY_SERVICECBs);
  DigitalInputService_AddService( selfEntity );
  DigitalInputService_RegisterAppCBs(&user_Digital_Input_ServiceCBs);

  // Placeholder variable for characteristic intialization
  uint8_t someVal[20] = {0};

  // Initalization of characteristics in LED_Service that are readable.
  LedService_SetParameter(LS_LED0_ID, LS_LED0_LEN, &someVal);
  LedService_SetParameter(LS_LED1_ID, LS_LED1_LEN, &someVal);

  // Initalization of characteristics in Button_Service that are readable.
  ButtonService_SetParameter(BS_BUTTON0_ID, BS_BUTTON0_LEN, &someVal);
  ButtonService_SetParameter(BS_BUTTON1_ID, BS_BUTTON1_LEN, &someVal);
  ButtonService_SetParameter(BS_BUTTON2_T1_ID, BS_BUTTON2_T1_LEN, &someVal);
  ButtonService_SetParameter(BS_BUTTON3_T2_ID, BS_BUTTON3_T2_LEN, &someVal);

  // Initalization of characteristics in Data_Service that are readable.
  DataService_SetParameter(DS_STRING_ID, DS_STRING_LEN, &someVal);

  // Initalization of characteristics in RELAY_SERVICE that are readable.
  RelayService_SetParameter(RS_RELAY1_ID, RS_RELAY1_LEN, &someVal);
  RelayService_SetParameter(RS_RELAY2_ID, RS_RELAY2_LEN, &someVal);

  // Initalization of characteristics in Digital_Input_Service that are readable.
  DigitalInputService_SetParameter(DIS_IN1_ID, DIS_IN1_LEN, &someVal);
  DigitalInputService_SetParameter(DIS_IN2_ID, DIS_IN2_LEN, &someVal);
  DigitalInputService_SetParameter(DIS_IN3_ID, DIS_IN3_LEN, &someVal);

//}


// taskFxn(..)
// {
//   for (;;) {
//     ... ICall_wait(...)   // Wait for semaphore post
// 
      // Process messages sent from another task or another context.
      while (!Queue_empty(hApplicationMsgQ))
      {
        app_msg_t   *pMsg = Queue_dequeue(hApplicationMsgQ);
        char_data_t *pCharData = (char_data_t *)pMsg->pdu;
        
        switch (pMsg->type)
        {
          case APP_MSG_SERVICE_WRITE: /* Message about received value write */
            /* Call different handler per service */
            switch(pCharData->svcUUID) {
              case LED_SERVICE_SERV_UUID:
                user_LedService_ValueChangeDispatchHandler(pCharData);
                break;
              case DATA_SERVICE_SERV_UUID:
                user_DataService_ValueChangeDispatchHandler(pCharData);
                break;
              case RELAY_SERVICE_SERV_UUID:
                user_RelayService_ValueChangeDispatchHandler(pCharData);
                break;
            }
          break;

          case APP_MSG_SERVICE_CFG: /* Message about received CCCD write */
            /* Call different handler per service */
            switch(pCharData->svcUUID) {
              case BUTTON_SERVICE_SERV_UUID:
                user_ButtonService_CfgChangeDispatchHandler(pCharData);
                break;
              case DATA_SERVICE_SERV_UUID:
                user_DataService_CfgChangeDispatchHandler(pCharData);
                break;
              case DIGITAL_INPUT_SERVICE_SERV_UUID:
                user_DigitalInputService_CfgChangeDispatchHandler(pCharData);
                break;
            }
          break;

          case APP_MSG_SEND_NOTIFICATION: /* Message to self from ClockSwi */
            user_updateCharVal(pCharData);
            break;
        }

        // Free the received message.
        ICall_free(pMsg);
      }

//   }
// }


/******************************************************************************
 *
 *  Handlers of system events deferred to the user Task context.
 *
 *****************************************************************************/


/**
 * Handle received characteristic write in task context.
 */
void user_LedService_ValueChangeDispatchHandler(char_data_t *pCharData)
{
  switch (pCharData->paramID)
  {
    case LS_LED0_ID:
      // Do something useful with pCharData->data here
      // -------------------------
      break;
    case LS_LED1_ID:
      // Do something useful with pCharData->data here
      // -------------------------
      break;
  }

}

/**
 * Handle received characteristic configuration change in task context..
 */
void user_ButtonService_CfgChangeDispatchHandler(char_data_t *pCharData)
{
  // Cast received data to uint16, as that's the format for CCCD writes.
  uint16_t configValue = *(uint16_t *)pCharData->data;

  switch (pCharData->paramID)
  {
    case BS_BUTTON0_ID:
      // Do something useful with configValue here
      // -------------------------
      if (configValue) // 0x0001 and 0x0002 both indicate turned on.
        Clock_start((Clock_Handle)&bs_BUTTON0_clock);
      else
        Clock_stop((Clock_Handle)&bs_BUTTON0_clock);
      break;
    case BS_BUTTON1_ID:
      // Do something useful with configValue here
      // -------------------------
      if (configValue) // 0x0001 and 0x0002 both indicate turned on.
        Clock_start((Clock_Handle)&bs_BUTTON1_clock);
      else
        Clock_stop((Clock_Handle)&bs_BUTTON1_clock);
      break;
    case BS_BUTTON2_T1_ID:
      // Do something useful with configValue here
      // -------------------------
      if (configValue) // 0x0001 and 0x0002 both indicate turned on.
        Clock_start((Clock_Handle)&bs_BUTTON2_T1_clock);
      else
        Clock_stop((Clock_Handle)&bs_BUTTON2_T1_clock);
      break;
    case BS_BUTTON3_T2_ID:
      // Do something useful with configValue here
      // -------------------------
      if (configValue) // 0x0001 and 0x0002 both indicate turned on.
        Clock_start((Clock_Handle)&bs_BUTTON3_T2_clock);
      else
        Clock_stop((Clock_Handle)&bs_BUTTON3_T2_clock);
      break;
  }
}

/**
 * Handle received characteristic write in task context.
 */
void user_DataService_ValueChangeDispatchHandler(char_data_t *pCharData)
{
  switch (pCharData->paramID)
  {
    case DS_STRING_ID:
      // Do something useful with pCharData->data here
      // -------------------------
      break;
    case DS_STREAM_ID:
      // Do something useful with pCharData->data here
      // -------------------------
      break;
  }

}

/**
 * Handle received characteristic configuration change in task context..
 */
void user_DataService_CfgChangeDispatchHandler(char_data_t *pCharData)
{
  // Cast received data to uint16, as that's the format for CCCD writes.
  uint16_t configValue = *(uint16_t *)pCharData->data;

  switch (pCharData->paramID)
  {
    case DS_STREAM_ID:
      // Do something useful with configValue here
      // -------------------------
      if (configValue) // 0x0001 and 0x0002 both indicate turned on.
        Clock_start((Clock_Handle)&ds_Stream_clock);
      else
        Clock_stop((Clock_Handle)&ds_Stream_clock);
      break;
  }
}

/**
 * Handle received characteristic write in task context.
 */
void user_RelayService_ValueChangeDispatchHandler(char_data_t *pCharData)
{
  switch (pCharData->paramID)
  {
    case RS_RELAY1_ID:
      // Do something useful with pCharData->data here
      // -------------------------
      break;
    case RS_RELAY2_ID:
      // Do something useful with pCharData->data here
      // -------------------------
      break;
  }

}

/**
 * Handle received characteristic configuration change in task context..
 */
void user_DigitalInputService_CfgChangeDispatchHandler(char_data_t *pCharData)
{
  // Cast received data to uint16, as that's the format for CCCD writes.
  uint16_t configValue = *(uint16_t *)pCharData->data;

  switch (pCharData->paramID)
  {
    case DIS_IN1_ID:
      // Do something useful with configValue here
      // -------------------------
      if (configValue) // 0x0001 and 0x0002 both indicate turned on.
        Clock_start((Clock_Handle)&dis_IN1_clock);
      else
        Clock_stop((Clock_Handle)&dis_IN1_clock);
      break;
    case DIS_IN2_ID:
      // Do something useful with configValue here
      // -------------------------
      if (configValue) // 0x0001 and 0x0002 both indicate turned on.
        Clock_start((Clock_Handle)&dis_IN2_clock);
      else
        Clock_stop((Clock_Handle)&dis_IN2_clock);
      break;
    case DIS_IN3_ID:
      // Do something useful with configValue here
      // -------------------------
      if (configValue) // 0x0001 and 0x0002 both indicate turned on.
        Clock_start((Clock_Handle)&dis_IN3_clock);
      else
        Clock_stop((Clock_Handle)&dis_IN3_clock);
      break;
  }
}

/**
 * Convenience function for updating characteristic data via char_data_t message
 * MUST run in Task context.
 */
static void user_updateCharVal(char_data_t *pCharData)
{
  switch(pCharData->svcUUID) {
    case LED_SERVICE_SERV_UUID:
      LedService_SetParameter( pCharData->paramID, pCharData->dataLen, pCharData->data );
    break;

    case BUTTON_SERVICE_SERV_UUID:
      ButtonService_SetParameter( pCharData->paramID, pCharData->dataLen, pCharData->data );
    break;

    case DATA_SERVICE_SERV_UUID:
      DataService_SetParameter( pCharData->paramID, pCharData->dataLen, pCharData->data );
    break;

    case RELAY_SERVICE_SERV_UUID:
      RelayService_SetParameter( pCharData->paramID, pCharData->dataLen, pCharData->data );
    break;

    case DIGITAL_INPUT_SERVICE_SERV_UUID:
      DigitalInputService_SetParameter( pCharData->paramID, pCharData->dataLen, pCharData->data );
    break;

  }
}


/******************************************************************************
 *
 *  Handlers for callbacks occurring in other run-time contexts
 *  than the user Task context.
 *
 *****************************************************************************/

/*
 *  Callbacks from the Stack Task context
 *****************************************************************************/



/**
 * Callback handler for characteristic value changes in LED Service, registered with the service.
 */
static void user_LedService_ValueChangeCB(uint16_t connHandle, uint8_t paramID, uint8_t *pValue, uint16_t len )
{
  // See LED_Service.h to compare paramID with characteristic value attribute.
  user_enqueueCharDataMsg(APP_MSG_SERVICE_WRITE, LED_SERVICE_SERV_UUID, connHandle, paramID, pValue, len);
}

/**
 * Callback handler for characteristic configuration changes in Button Service, registered with the service.
 */
static void user_ButtonService_CfgChangeCB( uint16_t connHandle, uint8_t paramID, uint8_t *pValue, uint16_t len )
{
  user_enqueueCharDataMsg(APP_MSG_SERVICE_CFG, BUTTON_SERVICE_SERV_UUID, connHandle, paramID, pValue, len);
}

/**
 * Callback handler for characteristic value changes in Data Service, registered with the service.
 */
static void user_DataService_ValueChangeCB(uint16_t connHandle, uint8_t paramID, uint8_t *pValue, uint16_t len )
{
  // See Data_Service.h to compare paramID with characteristic value attribute.
  user_enqueueCharDataMsg(APP_MSG_SERVICE_WRITE, DATA_SERVICE_SERV_UUID, connHandle, paramID, pValue, len);
}

/**
 * Callback handler for characteristic configuration changes in Data Service, registered with the service.
 */
static void user_DataService_CfgChangeCB( uint16_t connHandle, uint8_t paramID, uint8_t *pValue, uint16_t len )
{
  user_enqueueCharDataMsg(APP_MSG_SERVICE_CFG, DATA_SERVICE_SERV_UUID, connHandle, paramID, pValue, len);
}

/**
 * Callback handler for characteristic value changes in RELAY SERVICE, registered with the service.
 */
static void user_RelayService_ValueChangeCB(uint16_t connHandle, uint8_t paramID, uint8_t *pValue, uint16_t len )
{
  // See RELAY_SERVICE.h to compare paramID with characteristic value attribute.
  user_enqueueCharDataMsg(APP_MSG_SERVICE_WRITE, RELAY_SERVICE_SERV_UUID, connHandle, paramID, pValue, len);
}

/**
 * Callback handler for characteristic configuration changes in Digital Input Service, registered with the service.
 */
static void user_DigitalInputService_CfgChangeCB( uint16_t connHandle, uint8_t paramID, uint8_t *pValue, uint16_t len )
{
  user_enqueueCharDataMsg(APP_MSG_SERVICE_CFG, DIGITAL_INPUT_SERVICE_SERV_UUID, connHandle, paramID, pValue, len);
}


/*
 *  Callbacks from Swi-context
 *****************************************************************************/
static void user_ButtonService_clockSwiHandler(UArg paramID)
{
  uint8_t notiData[20];
  uint16_t notiLen = sizeof notiData;
  static uint8_t someCounter = 0;

  // Get loopback data if char is writable, otherwise fill with junk
  switch(paramID) {
    case BS_BUTTON0_ID:
      // Characteristic is not writable, so send something, max 20 bytes (max default ATT MTU size minus header)
      notiLen = MIN(notiLen, BS_BUTTON0_LEN);
      memset(notiData, someCounter++, notiLen);
    break;
    case BS_BUTTON1_ID:
      // Characteristic is not writable, so send something, max 20 bytes (max default ATT MTU size minus header)
      notiLen = MIN(notiLen, BS_BUTTON1_LEN);
      memset(notiData, someCounter++, notiLen);
    break;
    case BS_BUTTON2_T1_ID:
      // Characteristic is not writable, so send something, max 20 bytes (max default ATT MTU size minus header)
      notiLen = MIN(notiLen, BS_BUTTON2_T1_LEN);
      memset(notiData, someCounter++, notiLen);
    break;
    case BS_BUTTON3_T2_ID:
      // Characteristic is not writable, so send something, max 20 bytes (max default ATT MTU size minus header)
      notiLen = MIN(notiLen, BS_BUTTON3_T2_LEN);
      memset(notiData, someCounter++, notiLen);
    break;
  }

  // Send message to application that paramID (argument bound to the Clock_Struct) of
  // Button Service should emit a notification or indication.
  user_enqueueCharDataMsg(APP_MSG_SEND_NOTIFICATION, BUTTON_SERVICE_SERV_UUID, 0xFFFF, paramID, notiData, notiLen);
}
static void user_DataService_clockSwiHandler(UArg paramID)
{
  uint8_t notiData[20];
  uint16_t notiLen = sizeof notiData;

  // Get loopback data if char is writable, otherwise fill with junk
  switch(paramID) {
    case DS_STREAM_ID:
      // Characteristic is writable, so echo back contents.
      DataService_GetParameter( paramID, &notiLen, notiData );
    break;
  }

  // Send message to application that paramID (argument bound to the Clock_Struct) of
  // Data Service should emit a notification or indication.
  user_enqueueCharDataMsg(APP_MSG_SEND_NOTIFICATION, DATA_SERVICE_SERV_UUID, 0xFFFF, paramID, notiData, notiLen);
}
static void user_DigitalInputService_clockSwiHandler(UArg paramID)
{
  uint8_t notiData[20];
  uint16_t notiLen = sizeof notiData;
  static uint8_t someCounter = 0;

  // Get loopback data if char is writable, otherwise fill with junk
  switch(paramID) {
    case DIS_IN1_ID:
      // Characteristic is not writable, so send something, max 20 bytes (max default ATT MTU size minus header)
      notiLen = MIN(notiLen, DIS_IN1_LEN);
      memset(notiData, someCounter++, notiLen);
    break;
    case DIS_IN2_ID:
      // Characteristic is not writable, so send something, max 20 bytes (max default ATT MTU size minus header)
      notiLen = MIN(notiLen, DIS_IN2_LEN);
      memset(notiData, someCounter++, notiLen);
    break;
    case DIS_IN3_ID:
      // Characteristic is not writable, so send something, max 20 bytes (max default ATT MTU size minus header)
      notiLen = MIN(notiLen, DIS_IN3_LEN);
      memset(notiData, someCounter++, notiLen);
    break;
  }

  // Send message to application that paramID (argument bound to the Clock_Struct) of
  // Digital Input Service should emit a notification or indication.
  user_enqueueCharDataMsg(APP_MSG_SEND_NOTIFICATION, DIGITAL_INPUT_SERVICE_SERV_UUID, 0xFFFF, paramID, notiData, notiLen);
}




/******************************************************************************
 *
 *  Utility functions
 *
 *****************************************************************************/

/**
 * Generic message constructor for characteristic data.
 * Sends a message to the application for handling in Task context.
 */
static void user_enqueueCharDataMsg( app_msg_types_t appMsgType, uint16_t serviceUUID, 
                                       uint16_t connHandle, uint8_t paramID, 
                                       uint8_t *pValue, uint16_t len )
{
  // Called in Stack Task context, so can't do processing here.
  // Send message to application message queue about received data.
  uint16_t readLen = len; // How much data was written to the attribute
  
  // Allocate memory for the message.
  // Note: The pCharData message doesn't have to contain the data itself, as that's stored in
  //       a variable in the service. However, to prevent data loss if a new value is received
  //       before GetParameter is called, we call GetParameter now.
  app_msg_t *pMsg = ICall_malloc( sizeof(app_msg_t) + sizeof(char_data_t) + readLen );

  if (pMsg != NULL)
  {
    pMsg->type = appMsgType;
    
    char_data_t *pCharData = pMsg->pdu;
    pCharData->svcUUID = serviceUUID; // Use 16-bit part of UUID.
    pCharData->paramID = paramID;
    // Copy data from service now, because it could change before GetParameter is called later.
    memcpy(pCharData->data, pValue, readLen);
    // Update pCharData with how much data we received.
    pCharData->dataLen = readLen;
    // Enqueue the message using pointer to queue node element.
    Queue_enqueue(hApplicationMsgQ, &pMsg->_elem);
    // Let application know there's a message.
    Semaphore_post(sem);
  }
}

/**
 * Generic message constructor for raw data.
 * Sends a message to the application for handling in Task context.
 */
static void user_enqueueRawAppMsg( app_msg_types_t appMsgType, uint8_t *pData, uint16_t len );
{
  // Allocate memory for the message.
  // Note: The pCharData message doesn't have to contain the data itself, as that's stored in
  //       a variable in the service. However, to prevent data loss if a new value is received
  //       before GetParameter is called, we call GetParameter now.
  app_msg_t *pMsg = ICall_malloc( sizeof(app_msg_t) + len );

  if (pMsg != NULL)
  {
    pMsg->type = appMsgType;
    
    // Copy data from service now, because it could change before GetParameter is called later.
    memcpy(pMsg->pdu, pData, len);
    // Update pCharData with how much data we received.
    pCharData->dataLen = len;
    // Enqueue the message using pointer to queue node element.
    Queue_enqueue(hApplicationMsgQ, &pMsg->_elem);
    // Let application know there's a message.
    Semaphore_post(sem);
  }
}